package suitcaseisolationtesting;

/**
 * Interface for a list that is constrained by a weight limit.
 * Items can be added and removed from the list and the list
 * automatically tracks the available weight left in the list.
 *
 * @author jdalbey
 */
public interface I_WeightConstrainedList
{
    /**
     * Default weight limit in pounds
     */
    int kDefaultWeightLimit = 45;

    /**
     * Accessor to the available weight remaining in the list,
     * that is, unused weight.
     * @return remaining weight
     */
    int getRemainingWeight();

    /**
     * Adds up the total weight taken by the items in this list.
     * @return int total weight
     */
    int getTotalWeight();

    /**
     * Determine if the list has room for a specific piece of gear.
     * I.e., if this item were added to the list, would it
     * exceed the list's capacity?
     * @ return true if the item can fit, false otherwise.
     */
    boolean notFull(TravelGear newItem);

    /**
     * Appends the specified element to the end of this list.
     * @param newItem - element to be appended to this list.
     * @return true (as per the general contract of Collection.add).
     */
    boolean add(TravelGear newItem);

    /**
     * Returns the number of elements in this list.
     * @return the number of elements in this list.
     */
    int size();
}
