package suitcaseisolationtesting;

import java.io.File;
import java.util.ArrayList;
/**
 * SuitcasePacker represents a tool that can fill a suitcase
 * from a list of desired items to take traveling.
 * In this version, the "Fake" dependency name is passed into the constructor,
 * which means the class doesn't need to be recompiled for integration testing.
 *
 */
public class SuitcasePacker
{
    private I_WeightConstrainedList suitcase;
    private ArrayList<TravelGear> packableItems;

    /** Constructor for objects of type Suitcase */
    public SuitcasePacker(ArrayList<TravelGear> desiredItems, I_WeightConstrainedList bag)
    {
        suitcase = bag;
        packableItems = desiredItems;
    }
    /** Attempt to put an item in the suitcase, subject to a weight limit.
     * @param position the zero-based index of the item to be moved.
     * @return true if the item was added to the suitcase, false if adding
     * the item would have exceeded the current weight limit.
     */
    public boolean addToCase(int position)
    {
        // Is there room in the suitcase for another item?
        if (suitcase.notFull(packableItems.get(position)))
        {
            suitcase.add(packableItems.remove(position));
            return true;
        }
        return false;
    }
    /** Returns the number of items in the suitcase.
     * @return the number of items in the suitcase.
     */ 
    public int numItems()
    {
        return suitcase.size();
    }
}
