package suitcaseisolationtesting;

/**
 * TravelGear represents an item to take with you on a trip.
 * A piece of gear has a name and a weight.
 *
 */
public class TravelGear
{
    /**
     * The name of this gear.
     */
    private String gearName;
    /**
     * The weight of this gear.
     */
    private int weight;

    /** Construct a gear from its name and weight
     * @param name the name of the gear
     * @param weight the gear weight in pounds
     */
    public TravelGear(String name, int weight)
    {
        this.gearName = name;
        if (weight < 0)
        {
            weight = 0;
        }
        this.weight = weight;
    }
  
    /**
     * Returns the weight of this gear.
     *
     * @return The weight of this gear.
     */
    public int getWeight()
    {
        return weight;
    }

    /**
     * Returns a printable representation of this gear.
     *
     * @return gear return name as a string.
     */
    public String toString()
    {
        return gearName;
    }

}