package suitcaseisolationtesting;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.jmock.Mockery;
import org.jmock.Expectations;

public class SuitcasePackerUnitTest extends TestCase {
        Mockery context = new Mockery();

    public SuitcasePackerUnitTest(String testName) {
        super(testName);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testAddToCase()
    {
        System.out.println("unit test ONLY of addToCase");
        ArrayList<TravelGear> desiredGear = new ArrayList<TravelGear>();
        final TravelGear item0 = new TravelGear("A",1);
        final TravelGear item1 = new TravelGear("B",1);
        final TravelGear item2 = new TravelGear("C",46);
        desiredGear.add(item0); // position zero
        desiredGear.add(item1); // one
        desiredGear.add(item2); // two
        final I_WeightConstrainedList fake = context.mock(I_WeightConstrainedList.class);
        SuitcasePacker packer = new SuitcasePacker(desiredGear,fake);
        context.checking(new Expectations() {{
                oneOf (fake).size(); will(returnValue(0)); 
                oneOf (fake).notFull(item2); will(returnValue(false)); 
                oneOf (fake).notFull(item1); will(returnValue(true)); 
                oneOf (fake).add(item1); will(returnValue(true)); 
                oneOf (fake).size(); will(returnValue(1)); 
                never (fake).add(item0); will(returnValue(true));
                never (fake).add(item2); will(returnValue(false));
        }});
        // check that playlist size is empty
        assertEquals(0,packer.numItems());
        // item in position 2 is too big
        assertFalse(packer.addToCase(2));
        // add an item that fits
        assertTrue(packer.addToCase(1));
        // Verify suitcase now has one item
        assertEquals(1,packer.numItems());
        assertEquals(2,desiredGear.size());
        // verify the proper item was removed from desiredGear
        assertEquals("A",desiredGear.get(0).toString());
        assertEquals("C",desiredGear.get(1).toString());
        context.assertIsSatisfied();
    }


}
