/*
 * Decompiled with CFR 0.152.
 */
package org.mockito;

import org.mockito.ArgumentMatcher;
import org.mockito.internal.matchers.ArrayEquals;
import org.mockito.internal.matchers.CompareEqual;
import org.mockito.internal.matchers.EqualsWithDelta;
import org.mockito.internal.matchers.Find;
import org.mockito.internal.matchers.GreaterOrEqual;
import org.mockito.internal.matchers.GreaterThan;
import org.mockito.internal.matchers.LessOrEqual;
import org.mockito.internal.matchers.LessThan;
import org.mockito.internal.progress.HandyReturnValues;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.ThreadSafeMockingProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdditionalMatchers {
    private static MockingProgress mockingProgress = new ThreadSafeMockingProgress();

    public static <T extends Comparable<T>> T geq(Comparable<T> value) {
        return (T)((Comparable)AdditionalMatchers.reportMatcher(new GreaterOrEqual<T>(value)).returnNull());
    }

    public static byte geq(byte value) {
        return AdditionalMatchers.reportMatcher(new GreaterOrEqual<Byte>(Byte.valueOf(value))).returnZero();
    }

    public static double geq(double value) {
        return AdditionalMatchers.reportMatcher(new GreaterOrEqual<Double>(Double.valueOf(value))).returnZero();
    }

    public static float geq(float value) {
        return AdditionalMatchers.reportMatcher(new GreaterOrEqual<Float>(Float.valueOf(value))).returnZero();
    }

    public static int geq(int value) {
        return AdditionalMatchers.reportMatcher(new GreaterOrEqual<Integer>(Integer.valueOf(value))).returnZero();
    }

    public static long geq(long value) {
        return AdditionalMatchers.reportMatcher(new GreaterOrEqual<Long>(Long.valueOf(value))).returnZero();
    }

    public static short geq(short value) {
        return AdditionalMatchers.reportMatcher(new GreaterOrEqual<Short>(Short.valueOf(value))).returnZero();
    }

    public static <T extends Comparable<T>> T leq(Comparable<T> value) {
        return (T)((Comparable)AdditionalMatchers.reportMatcher(new LessOrEqual<T>(value)).returnNull());
    }

    public static byte leq(byte value) {
        return AdditionalMatchers.reportMatcher(new LessOrEqual<Byte>(Byte.valueOf(value))).returnZero();
    }

    public static double leq(double value) {
        return AdditionalMatchers.reportMatcher(new LessOrEqual<Double>(Double.valueOf(value))).returnZero();
    }

    public static float leq(float value) {
        return AdditionalMatchers.reportMatcher(new LessOrEqual<Float>(Float.valueOf(value))).returnZero();
    }

    public static int leq(int value) {
        return AdditionalMatchers.reportMatcher(new LessOrEqual<Integer>(Integer.valueOf(value))).returnZero();
    }

    public static long leq(long value) {
        return AdditionalMatchers.reportMatcher(new LessOrEqual<Long>(Long.valueOf(value))).returnZero();
    }

    public static short leq(short value) {
        return AdditionalMatchers.reportMatcher(new LessOrEqual<Short>(Short.valueOf(value))).returnZero();
    }

    public static <T extends Comparable<T>> T gt(Comparable<T> value) {
        return (T)((Comparable)AdditionalMatchers.reportMatcher(new GreaterThan<T>(value)).returnNull());
    }

    public static byte gt(byte value) {
        return AdditionalMatchers.reportMatcher(new GreaterThan<Byte>(Byte.valueOf(value))).returnZero();
    }

    public static double gt(double value) {
        return AdditionalMatchers.reportMatcher(new GreaterThan<Double>(Double.valueOf(value))).returnZero();
    }

    public static float gt(float value) {
        return AdditionalMatchers.reportMatcher(new GreaterThan<Float>(Float.valueOf(value))).returnZero();
    }

    public static int gt(int value) {
        return AdditionalMatchers.reportMatcher(new GreaterThan<Integer>(Integer.valueOf(value))).returnZero();
    }

    public static long gt(long value) {
        return AdditionalMatchers.reportMatcher(new GreaterThan<Long>(Long.valueOf(value))).returnZero();
    }

    public static short gt(short value) {
        return AdditionalMatchers.reportMatcher(new GreaterThan<Short>(Short.valueOf(value))).returnZero();
    }

    public static <T extends Comparable<T>> T lt(Comparable<T> value) {
        return (T)((Comparable)AdditionalMatchers.reportMatcher(new LessThan<T>(value)).returnNull());
    }

    public static byte lt(byte value) {
        return AdditionalMatchers.reportMatcher(new LessThan<Byte>(Byte.valueOf(value))).returnZero();
    }

    public static double lt(double value) {
        return AdditionalMatchers.reportMatcher(new LessThan<Double>(Double.valueOf(value))).returnZero();
    }

    public static float lt(float value) {
        return AdditionalMatchers.reportMatcher(new LessThan<Float>(Float.valueOf(value))).returnZero();
    }

    public static int lt(int value) {
        return AdditionalMatchers.reportMatcher(new LessThan<Integer>(Integer.valueOf(value))).returnZero();
    }

    public static long lt(long value) {
        return AdditionalMatchers.reportMatcher(new LessThan<Long>(Long.valueOf(value))).returnZero();
    }

    public static short lt(short value) {
        return AdditionalMatchers.reportMatcher(new LessThan<Short>(Short.valueOf(value))).returnZero();
    }

    public static <T extends Comparable<T>> T cmpEq(Comparable<T> value) {
        return (T)((Comparable)AdditionalMatchers.reportMatcher(new CompareEqual<T>(value)).returnNull());
    }

    public static String find(String regex) {
        return (String)AdditionalMatchers.reportMatcher(new Find(regex)).returnNull();
    }

    public static <T> T[] aryEq(T[] value) {
        return (Object[])AdditionalMatchers.reportMatcher(new ArrayEquals(value)).returnNull();
    }

    public static short[] aryEq(short[] value) {
        return (short[])AdditionalMatchers.reportMatcher(new ArrayEquals(value)).returnNull();
    }

    public static long[] aryEq(long[] value) {
        return (long[])AdditionalMatchers.reportMatcher(new ArrayEquals(value)).returnNull();
    }

    public static int[] aryEq(int[] value) {
        return (int[])AdditionalMatchers.reportMatcher(new ArrayEquals(value)).returnNull();
    }

    public static float[] aryEq(float[] value) {
        return (float[])AdditionalMatchers.reportMatcher(new ArrayEquals(value)).returnNull();
    }

    public static double[] aryEq(double[] value) {
        return (double[])AdditionalMatchers.reportMatcher(new ArrayEquals(value)).returnNull();
    }

    public static char[] aryEq(char[] value) {
        return (char[])AdditionalMatchers.reportMatcher(new ArrayEquals(value)).returnNull();
    }

    public static byte[] aryEq(byte[] value) {
        return (byte[])AdditionalMatchers.reportMatcher(new ArrayEquals(value)).returnNull();
    }

    public static boolean[] aryEq(boolean[] value) {
        return (boolean[])AdditionalMatchers.reportMatcher(new ArrayEquals(value)).returnNull();
    }

    public static boolean and(boolean first, boolean second) {
        return mockingProgress.getArgumentMatcherStorage().reportAnd().returnFalse();
    }

    public static byte and(byte first, byte second) {
        return mockingProgress.getArgumentMatcherStorage().reportAnd().returnZero();
    }

    public static char and(char first, char second) {
        return mockingProgress.getArgumentMatcherStorage().reportAnd().returnChar();
    }

    public static double and(double first, double second) {
        return mockingProgress.getArgumentMatcherStorage().reportAnd().returnZero();
    }

    public static float and(float first, float second) {
        return mockingProgress.getArgumentMatcherStorage().reportAnd().returnZero();
    }

    public static int and(int first, int second) {
        return mockingProgress.getArgumentMatcherStorage().reportAnd().returnZero();
    }

    public static long and(long first, long second) {
        return mockingProgress.getArgumentMatcherStorage().reportAnd().returnZero();
    }

    public static short and(short first, short second) {
        return mockingProgress.getArgumentMatcherStorage().reportAnd().returnZero();
    }

    public static <T> T and(T first, T second) {
        return mockingProgress.getArgumentMatcherStorage().reportAnd().returnNull();
    }

    public static boolean or(boolean first, boolean second) {
        return mockingProgress.getArgumentMatcherStorage().reportOr().returnFalse();
    }

    public static <T> T or(T first, T second) {
        return mockingProgress.getArgumentMatcherStorage().reportOr().returnNull();
    }

    public static short or(short first, short second) {
        return mockingProgress.getArgumentMatcherStorage().reportOr().returnZero();
    }

    public static long or(long first, long second) {
        return mockingProgress.getArgumentMatcherStorage().reportOr().returnZero();
    }

    public static int or(int first, int second) {
        return mockingProgress.getArgumentMatcherStorage().reportOr().returnZero();
    }

    public static float or(float first, float second) {
        return mockingProgress.getArgumentMatcherStorage().reportOr().returnZero();
    }

    public static double or(double first, double second) {
        return mockingProgress.getArgumentMatcherStorage().reportOr().returnZero();
    }

    public static char or(char first, char second) {
        return mockingProgress.getArgumentMatcherStorage().reportOr().returnChar();
    }

    public static byte or(byte first, byte second) {
        return mockingProgress.getArgumentMatcherStorage().reportOr().returnZero();
    }

    public static <T> T not(T first) {
        return mockingProgress.getArgumentMatcherStorage().reportNot().returnNull();
    }

    public static short not(short first) {
        return mockingProgress.getArgumentMatcherStorage().reportNot().returnZero();
    }

    public static int not(int first) {
        return mockingProgress.getArgumentMatcherStorage().reportNot().returnZero();
    }

    public static long not(long first) {
        return mockingProgress.getArgumentMatcherStorage().reportNot().returnZero();
    }

    public static float not(float first) {
        return mockingProgress.getArgumentMatcherStorage().reportNot().returnZero();
    }

    public static double not(double first) {
        return mockingProgress.getArgumentMatcherStorage().reportNot().returnZero();
    }

    public static char not(char first) {
        return mockingProgress.getArgumentMatcherStorage().reportNot().returnChar();
    }

    public static boolean not(boolean first) {
        return mockingProgress.getArgumentMatcherStorage().reportNot().returnFalse();
    }

    public static byte not(byte first) {
        return mockingProgress.getArgumentMatcherStorage().reportNot().returnZero();
    }

    public static double eq(double value, double delta) {
        return AdditionalMatchers.reportMatcher(new EqualsWithDelta(value, delta)).returnZero();
    }

    public static float eq(float value, float delta) {
        return AdditionalMatchers.reportMatcher(new EqualsWithDelta(Float.valueOf(value), Float.valueOf(delta))).returnZero();
    }

    private static HandyReturnValues reportMatcher(ArgumentMatcher<?> matcher) {
        return mockingProgress.getArgumentMatcherStorage().reportMatcher(matcher);
    }
}

