/*
 * Decompiled with CFR 0.152.
 */
package org.mockito;

import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BDDMockito
extends Mockito {
    public static <T> BDDMyOngoingStubbing<T> given(T methodCall) {
        return new BDDOngoingStubbingImpl<T>(Mockito.when(methodCall));
    }

    public static BDDStubber willThrow(Throwable toBeThrown) {
        return new BDDStubberImpl(Mockito.doThrow(toBeThrown));
    }

    public static BDDStubber willThrow(Class<? extends Throwable> toBeThrown) {
        return new BDDStubberImpl(Mockito.doThrow(toBeThrown));
    }

    public static BDDStubber willAnswer(Answer answer) {
        return new BDDStubberImpl(Mockito.doAnswer(answer));
    }

    public static BDDStubber willDoNothing() {
        return new BDDStubberImpl(Mockito.doNothing());
    }

    public static BDDStubber willReturn(Object toBeReturned) {
        return new BDDStubberImpl(Mockito.doReturn(toBeReturned));
    }

    public static BDDStubber willCallRealMethod() {
        return new BDDStubberImpl(Mockito.doCallRealMethod());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BDDStubberImpl
    implements BDDStubber {
        private final Stubber mockitoStubber;

        public BDDStubberImpl(Stubber mockitoStubber) {
            this.mockitoStubber = mockitoStubber;
        }

        @Override
        public <T> T given(T mock) {
            return this.mockitoStubber.when(mock);
        }

        @Override
        public BDDStubber willAnswer(Answer answer) {
            return new BDDStubberImpl(this.mockitoStubber.doAnswer(answer));
        }

        @Override
        public BDDStubber willNothing() {
            return new BDDStubberImpl(this.mockitoStubber.doNothing());
        }

        @Override
        public BDDStubber willReturn(Object toBeReturned) {
            return new BDDStubberImpl(this.mockitoStubber.doReturn(toBeReturned));
        }

        @Override
        public BDDStubber willThrow(Throwable toBeThrown) {
            return new BDDStubberImpl(this.mockitoStubber.doThrow(toBeThrown));
        }

        @Override
        public BDDStubber willThrow(Class<? extends Throwable> toBeThrown) {
            return new BDDStubberImpl(this.mockitoStubber.doThrow(toBeThrown));
        }

        @Override
        public BDDStubber willCallRealMethod() {
            return new BDDStubberImpl(this.mockitoStubber.doCallRealMethod());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BDDStubber {
        public BDDStubber willAnswer(Answer var1);

        public BDDStubber willNothing();

        public BDDStubber willReturn(Object var1);

        public BDDStubber willThrow(Throwable var1);

        public BDDStubber willThrow(Class<? extends Throwable> var1);

        public BDDStubber willCallRealMethod();

        public <T> T given(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BDDOngoingStubbingImpl<T>
    implements BDDMyOngoingStubbing<T> {
        private final OngoingStubbing<T> mockitoOngoingStubbing;

        public BDDOngoingStubbingImpl(OngoingStubbing<T> ongoingStubbing) {
            this.mockitoOngoingStubbing = ongoingStubbing;
        }

        @Override
        public BDDMyOngoingStubbing<T> willAnswer(Answer<?> answer) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenAnswer(answer));
        }

        @Override
        public BDDMyOngoingStubbing<T> will(Answer<?> answer) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.then(answer));
        }

        @Override
        public BDDMyOngoingStubbing<T> willReturn(T value) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenReturn(value));
        }

        @Override
        public BDDMyOngoingStubbing<T> willReturn(T value, T ... values) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenReturn(value, values));
        }

        @Override
        public BDDMyOngoingStubbing<T> willThrow(Throwable ... throwables) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenThrow(throwables));
        }

        @Override
        public BDDMyOngoingStubbing<T> willThrow(Class<? extends Throwable> ... throwableClasses) {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenThrow(throwableClasses));
        }

        @Override
        public BDDMyOngoingStubbing<T> willCallRealMethod() {
            return new BDDOngoingStubbingImpl<T>(this.mockitoOngoingStubbing.thenCallRealMethod());
        }

        @Override
        public <M> M getMock() {
            return this.mockitoOngoingStubbing.getMock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BDDMyOngoingStubbing<T> {
        public BDDMyOngoingStubbing<T> willAnswer(Answer<?> var1);

        public BDDMyOngoingStubbing<T> will(Answer<?> var1);

        public BDDMyOngoingStubbing<T> willReturn(T var1);

        public BDDMyOngoingStubbing<T> willReturn(T var1, T ... var2);

        public BDDMyOngoingStubbing<T> willThrow(Throwable ... var1);

        public BDDMyOngoingStubbing<T> willThrow(Class<? extends Throwable> ... var1);

        public BDDMyOngoingStubbing<T> willCallRealMethod();

        public <M> M getMock();
    }
}

