/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal;

import java.util.LinkedList;
import java.util.List;
import org.mockito.InOrder;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.MockitoCore;
import org.mockito.internal.verification.InOrderContextImpl;
import org.mockito.internal.verification.InOrderWrapper;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.internal.verification.api.VerificationInOrderMode;
import org.mockito.invocation.Invocation;
import org.mockito.verification.VerificationMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InOrderImpl
implements InOrder,
InOrderContext {
    private final MockitoCore mockitoCore = new MockitoCore();
    private final Reporter reporter = new Reporter();
    private final List<Object> mocksToBeVerifiedInOrder = new LinkedList<Object>();
    private final InOrderContext inOrderContext = new InOrderContextImpl();

    public List<Object> getMocksToBeVerifiedInOrder() {
        return this.mocksToBeVerifiedInOrder;
    }

    public InOrderImpl(List<Object> mocksToBeVerifiedInOrder) {
        this.mocksToBeVerifiedInOrder.addAll(mocksToBeVerifiedInOrder);
    }

    @Override
    public <T> T verify(T mock) {
        return this.verify(mock, VerificationModeFactory.times(1));
    }

    @Override
    public <T> T verify(T mock, VerificationMode mode) {
        if (!this.mocksToBeVerifiedInOrder.contains(mock)) {
            this.reporter.inOrderRequiresFamiliarMock();
        } else if (!(mode instanceof VerificationInOrderMode)) {
            throw new MockitoException(mode.getClass().getSimpleName() + " is not implemented to work with InOrder");
        }
        return this.mockitoCore.verify(mock, new InOrderWrapper((VerificationInOrderMode)((Object)mode), this));
    }

    @Override
    public boolean isVerified(Invocation i) {
        return this.inOrderContext.isVerified(i);
    }

    @Override
    public void markVerified(Invocation i) {
        this.inOrderContext.markVerified(i);
    }

    @Override
    public void verifyNoMoreInteractions() {
        this.mockitoCore.verifyNoMoreInteractionsInOrder(this.mocksToBeVerifiedInOrder, this);
    }
}

