/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.internal.configuration.DefaultAnnotationEngine;
import org.mockito.internal.configuration.DefaultInjectionEngine;
import org.mockito.internal.configuration.SpyAnnotationEngine;
import org.mockito.internal.configuration.injection.scanner.InjectMocksScanner;
import org.mockito.internal.configuration.injection.scanner.MockScanner;
import org.mockito.internal.util.collections.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectingAnnotationEngine
implements AnnotationEngine {
    private AnnotationEngine delegate = new DefaultAnnotationEngine();
    private AnnotationEngine spyAnnotationEngine = new SpyAnnotationEngine();

    @Override
    @Deprecated
    public Object createMockFor(Annotation annotation, Field field) {
        return this.delegate.createMockFor(annotation, field);
    }

    @Override
    public void process(Class<?> clazz, Object testInstance) {
        this.processIndependentAnnotations(testInstance.getClass(), testInstance);
        this.processInjectMocks(testInstance.getClass(), testInstance);
    }

    private void processInjectMocks(Class<?> clazz, Object testInstance) {
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            this.injectMocks(testInstance);
        }
    }

    private void processIndependentAnnotations(Class<?> clazz, Object testInstance) {
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            this.delegate.process(classContext, testInstance);
            this.spyAnnotationEngine.process(classContext, testInstance);
        }
    }

    public void injectMocks(Object testClassInstance) {
        HashSet<Field> mockDependentFields = new HashSet<Field>();
        Set<Object> mocks = Sets.newMockSafeHashSet(new Object[0]);
        for (Class<?> clazz = testClassInstance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            new InjectMocksScanner(clazz).addTo(mockDependentFields);
            new MockScanner(testClassInstance, clazz).addPreparedMocks(mocks);
        }
        new DefaultInjectionEngine().injectMocksOnFields(mockDependentFields, mocks, testClassInstance);
    }
}

