/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.debugging;

import org.mockito.internal.debugging.FindingsListener;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.util.MockitoLogger;
import org.mockito.internal.util.StringJoiner;
import org.mockito.invocation.Invocation;

public class LoggingListener
implements FindingsListener {
    private boolean warnAboutUnstubbed;
    private final MockitoLogger logger;

    public LoggingListener(boolean warnAboutUnstubbed, MockitoLogger logger) {
        this.warnAboutUnstubbed = warnAboutUnstubbed;
        this.logger = logger;
    }

    public void foundStubCalledWithDifferentArgs(Invocation unused, InvocationMatcher unstubbed) {
        this.logger.log(StringJoiner.join(" *** Stubbing warnings from Mockito: *** ", "", "stubbed with those args here   " + unused.getLocation(), "BUT called with different args " + unstubbed.getInvocation().getLocation(), ""));
    }

    public void foundUnusedStub(Invocation unused) {
        this.logger.log("This stubbing was never used   " + unused.getLocation() + "\n");
    }

    public void foundUnstubbed(InvocationMatcher unstubbed) {
        if (this.warnAboutUnstubbed) {
            this.logger.log(StringJoiner.join("This method was not stubbed ", unstubbed, unstubbed.getInvocation().getLocation(), ""));
        }
    }

    public boolean isWarnAboutUnstubbed() {
        return this.warnAboutUnstubbed;
    }

    public MockitoLogger getLogger() {
        return this.logger;
    }
}

