/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.mockito.internal.invocation.ArgumentsComparator;
import org.mockito.internal.invocation.ArgumentsProcessor;
import org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import org.mockito.internal.matchers.CapturesArguments;
import org.mockito.internal.reporting.PrintSettings;
import org.mockito.invocation.DescribedInvocation;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationMatcher
implements DescribedInvocation,
CapturesArgumensFromInvocation,
Serializable {
    private static final long serialVersionUID = -3047126096857467610L;
    private final Invocation invocation;
    private final List<Matcher> matchers;

    public InvocationMatcher(Invocation invocation, List<Matcher> matchers) {
        this.invocation = invocation;
        this.matchers = matchers.isEmpty() ? ArgumentsProcessor.argumentsToMatchers(invocation.getArguments()) : matchers;
    }

    public InvocationMatcher(Invocation invocation) {
        this(invocation, Collections.emptyList());
    }

    public Method getMethod() {
        return this.invocation.getMethod();
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public List<Matcher> getMatchers() {
        return this.matchers;
    }

    @Override
    public String toString() {
        return new PrintSettings().print(this.matchers, this.invocation);
    }

    public boolean matches(Invocation actual) {
        return this.invocation.getMock().equals(actual.getMock()) && this.hasSameMethod(actual) && new ArgumentsComparator().argumentsMatch(this, actual);
    }

    private boolean safelyArgumentsMatch(Object[] actualArgs) {
        try {
            return new ArgumentsComparator().argumentsMatch(this, actualArgs);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean hasSimilarMethod(Invocation candidate) {
        String wantedMethodName = this.getMethod().getName();
        String currentMethodName = candidate.getMethod().getName();
        boolean methodNameEquals = wantedMethodName.equals(currentMethodName);
        boolean isUnverified = !candidate.isVerified();
        boolean mockIsTheSame = this.getInvocation().getMock() == candidate.getMock();
        boolean methodEquals = this.hasSameMethod(candidate);
        if (!(methodNameEquals && isUnverified && mockIsTheSame)) {
            return false;
        }
        boolean overloadedButSameArgs = !methodEquals && this.safelyArgumentsMatch(candidate.getArguments());
        return !overloadedButSameArgs;
    }

    public boolean hasSameMethod(Invocation candidate) {
        Class<?>[] params2;
        Class<?>[] params1;
        Method m1 = this.invocation.getMethod();
        Method m2 = candidate.getMethod();
        if (m1.getName() != null && m1.getName().equals(m2.getName()) && (params1 = m1.getParameterTypes()).length == (params2 = m2.getParameterTypes()).length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Location getLocation() {
        return this.invocation.getLocation();
    }

    @Override
    public void captureArgumentsFrom(Invocation i) {
        int k = 0;
        for (Matcher m : this.matchers) {
            if (m instanceof CapturesArguments && i.getArguments().length > k) {
                ((CapturesArguments)((Object)m)).captureFrom(i.getArguments()[k]);
            }
            ++k;
        }
    }

    public static List<InvocationMatcher> createFrom(List<Invocation> invocations) {
        LinkedList<InvocationMatcher> out = new LinkedList<InvocationMatcher>();
        for (Invocation i : invocations) {
            out.add(new InvocationMatcher(i));
        }
        return out;
    }
}

