/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation.finder;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.util.MockUtil;
import org.mockito.invocation.Invocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllInvocationsFinder {
    public List<Invocation> find(List<?> mocks) {
        TreeSet<Invocation> invocationsInOrder = new TreeSet<Invocation>(new SequenceNumberComparator());
        for (Object mock : mocks) {
            InternalMockHandler<?> handler = new MockUtil().getMockHandler(mock);
            List<Invocation> fromSingleMock = handler.getInvocationContainer().getInvocations();
            invocationsInOrder.addAll(fromSingleMock);
        }
        return new LinkedList<Invocation>(invocationsInOrder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SequenceNumberComparator
    implements Comparator<Invocation> {
        private SequenceNumberComparator() {
        }

        @Override
        public int compare(Invocation o1, Invocation o2) {
            return Integer.valueOf(o1.getSequenceNumber()).compareTo(o2.getSequenceNumber());
        }
    }
}

