/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.listeners;

import org.mockito.invocation.DescribedInvocation;
import org.mockito.invocation.Invocation;
import org.mockito.listeners.MethodInvocationReport;

public class NotifiedMethodInvocationReport
implements MethodInvocationReport {
    private final Invocation invocation;
    private Object returnedValue;
    private Throwable throwable;

    public NotifiedMethodInvocationReport(Invocation invocation, Object returnedValue) {
        this.invocation = invocation;
        this.returnedValue = returnedValue;
    }

    public NotifiedMethodInvocationReport(Invocation invocation, Throwable throwable) {
        this.invocation = invocation;
        this.throwable = throwable;
    }

    public DescribedInvocation getInvocation() {
        return this.invocation;
    }

    public Object getReturnedValue() {
        return this.returnedValue;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean threwException() {
        return this.throwable != null;
    }

    public String getLocationOfStubbing() {
        return this.invocation.stubInfo() == null ? null : ((Object)this.invocation.stubInfo().stubbedAt()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotifiedMethodInvocationReport that = (NotifiedMethodInvocationReport)o;
        if (this.invocation != null ? !this.invocation.equals(that.invocation) : that.invocation != null) {
            return false;
        }
        if (this.returnedValue != null ? !this.returnedValue.equals(that.returnedValue) : that.returnedValue != null) {
            return false;
        }
        return !(this.throwable != null ? !this.throwable.equals(that.throwable) : that.throwable != null);
    }

    public int hashCode() {
        int result = this.invocation != null ? this.invocation.hashCode() : 0;
        result = 31 * result + (this.returnedValue != null ? this.returnedValue.hashCode() : 0);
        result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
        return result;
    }
}

