/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.progress;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mockito.internal.util.Primitives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandyReturnValues {
    public byte returnZero() {
        return 0;
    }

    public char returnChar() {
        return '\u0000';
    }

    public <T> T returnNull() {
        return null;
    }

    public boolean returnFalse() {
        return false;
    }

    public String returnString() {
        return "";
    }

    public <T> T returnFor(Class<T> clazz) {
        if (Primitives.isPrimitiveOrWrapper(clazz)) {
            return Primitives.defaultValueForPrimitiveOrWrapper(clazz);
        }
        return null;
    }

    public Map returnMap() {
        return new HashMap();
    }

    public List returnList() {
        return new LinkedList();
    }

    public Set returnSet() {
        return new HashSet();
    }

    public <T> T returnFor(T instance) {
        return (T)(instance == null ? null : this.returnFor((T)instance.getClass()));
    }
}

