/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Primitives {
    private static Map<Class<?>, Class<?>> primitiveTypes = new HashMap();
    private static Map<Class<?>, Object> primitiveOrWrapperDefaultValues = new HashMap();

    public static <T> Class<T> primitiveTypeOf(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            return clazz;
        }
        return primitiveTypes.get(clazz);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        return primitiveOrWrapperDefaultValues.containsKey(type);
    }

    public static <T> T defaultValueForPrimitiveOrWrapper(Class<T> primitiveOrWrapperType) {
        return (T)primitiveOrWrapperDefaultValues.get(primitiveOrWrapperType);
    }

    static {
        primitiveTypes.put(Boolean.class, Boolean.TYPE);
        primitiveTypes.put(Character.class, Character.TYPE);
        primitiveTypes.put(Byte.class, Byte.TYPE);
        primitiveTypes.put(Short.class, Short.TYPE);
        primitiveTypes.put(Integer.class, Integer.TYPE);
        primitiveTypes.put(Long.class, Long.TYPE);
        primitiveTypes.put(Float.class, Float.TYPE);
        primitiveTypes.put(Double.class, Double.TYPE);
        primitiveOrWrapperDefaultValues.put(Boolean.class, false);
        primitiveOrWrapperDefaultValues.put(Character.class, Character.valueOf('\u0000'));
        primitiveOrWrapperDefaultValues.put(Byte.class, (byte)0);
        primitiveOrWrapperDefaultValues.put(Short.class, (short)0);
        primitiveOrWrapperDefaultValues.put(Integer.class, 0);
        primitiveOrWrapperDefaultValues.put(Long.class, 0L);
        primitiveOrWrapperDefaultValues.put(Float.class, Float.valueOf(0.0f));
        primitiveOrWrapperDefaultValues.put(Double.class, 0.0);
        primitiveOrWrapperDefaultValues.put(Boolean.TYPE, false);
        primitiveOrWrapperDefaultValues.put(Character.TYPE, Character.valueOf('\u0000'));
        primitiveOrWrapperDefaultValues.put(Byte.TYPE, (byte)0);
        primitiveOrWrapperDefaultValues.put(Short.TYPE, (short)0);
        primitiveOrWrapperDefaultValues.put(Integer.TYPE, 0);
        primitiveOrWrapperDefaultValues.put(Long.TYPE, 0L);
        primitiveOrWrapperDefaultValues.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveOrWrapperDefaultValues.put(Double.TYPE, 0.0);
    }
}

