/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.mockito.Incubating;
import org.mockito.internal.util.Checks;
import org.mockito.internal.util.collections.ListUtil;
import org.mockito.internal.util.reflection.InstanceField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public abstract class Fields {
    public static InstanceFields allDeclaredFieldsOf(Object instance) {
        ArrayList<InstanceField> instanceFields = new ArrayList<InstanceField>();
        for (Class<?> clazz = instance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            instanceFields.addAll(Fields.instanceFieldsIn(instance, clazz.getDeclaredFields()));
        }
        return new InstanceFields(instance, instanceFields);
    }

    public static InstanceFields declaredFieldsOf(Object instance) {
        ArrayList<InstanceField> instanceFields = new ArrayList<InstanceField>();
        instanceFields.addAll(Fields.instanceFieldsIn(instance, instance.getClass().getDeclaredFields()));
        return new InstanceFields(instance, instanceFields);
    }

    private static List<InstanceField> instanceFieldsIn(Object instance, Field[] fields) {
        ArrayList<InstanceField> instanceDeclaredFields = new ArrayList<InstanceField>();
        for (Field field : fields) {
            InstanceField instanceField = new InstanceField(field, instance);
            instanceDeclaredFields.add(instanceField);
        }
        return instanceDeclaredFields;
    }

    public static ListUtil.Filter<InstanceField> annotatedBy(final Class<? extends Annotation> ... annotations) {
        return new ListUtil.Filter<InstanceField>(){

            @Override
            public boolean isOut(InstanceField instanceField) {
                Checks.checkNotNull(annotations, "Provide at least one annotation class");
                for (Class annotation : annotations) {
                    if (!instanceField.isAnnotatedBy(annotation)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static ListUtil.Filter<InstanceField> nullField() {
        return new ListUtil.Filter<InstanceField>(){

            @Override
            public boolean isOut(InstanceField instanceField) {
                return instanceField.isNull();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstanceFields {
        private final Object instance;
        private final List<InstanceField> instanceFields;

        public InstanceFields(Object instance, List<InstanceField> instanceFields) {
            this.instance = instance;
            this.instanceFields = instanceFields;
        }

        public InstanceFields filter(ListUtil.Filter<InstanceField> withFilter) {
            return new InstanceFields(this.instance, ListUtil.filter(this.instanceFields, withFilter));
        }

        public InstanceFields notNull() {
            return this.filter(Fields.nullField());
        }

        public List<InstanceField> instanceFields() {
            return new ArrayList<InstanceField>(this.instanceFields);
        }

        public List<Object> assignedValues() {
            ArrayList<Object> values = new ArrayList<Object>(this.instanceFields.size());
            for (InstanceField instanceField : this.instanceFields) {
                values.add(instanceField.read());
            }
            return values;
        }

        public List<String> names() {
            ArrayList<String> fieldNames = new ArrayList<String>(this.instanceFields.size());
            for (InstanceField instanceField : this.instanceFields) {
                fieldNames.add(instanceField.name());
            }
            return fieldNames;
        }
    }
}

