/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.invocation.Invocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerificationDataImpl
implements VerificationData {
    private final InvocationMatcher wanted;
    private final InvocationContainer invocations;

    public VerificationDataImpl(InvocationContainer invocations, InvocationMatcher wanted) {
        this.invocations = invocations;
        this.wanted = wanted;
        this.assertWantedIsVerifiable();
    }

    @Override
    public List<Invocation> getAllInvocations() {
        return this.invocations.getInvocations();
    }

    @Override
    public InvocationMatcher getWanted() {
        return this.wanted;
    }

    void assertWantedIsVerifiable() {
        if (this.wanted == null) {
            return;
        }
        ObjectMethodsGuru o = new ObjectMethodsGuru();
        if (o.isToString(this.wanted.getMethod())) {
            new Reporter().cannotVerifyToString();
        }
    }
}

