package suitcaseisolationtesting;

import java.util.ArrayList;
import junit.framework.TestCase;
import static org.mockito.Mockito.*;

public class SuitcasePackerTest extends TestCase {
    
    public SuitcasePackerTest(String testName) {
        super(testName);
    }

    ArrayList<TravelGear> desiredGear;

    /**
     * Test of addToCase method, of class SuitcasePacker.
     */
    public void testAddToCase()
    {
        System.out.println("test addToCase");
        desiredGear = new ArrayList<TravelGear>();
        final TravelGear item0 = new TravelGear("A",1);
        final TravelGear item1 = new TravelGear("B",1);
        final TravelGear item2 = new TravelGear("C",46);
        desiredGear.add(item0); // position zero
        desiredGear.add(item1); // one
        desiredGear.add(item2); // two

        WeightConstrainedList gearlist = mock(WeightConstrainedList.class);
        SuitcasePacker packer = new SuitcasePacker(desiredGear,gearlist);

        // check that playlist size is empty
        when(gearlist.size()).thenReturn(0);
        assertEquals(0,packer.numItems());
        // item in position 2 is too big
        when(gearlist.notFull(item2)).thenReturn(false);
        assertFalse(packer.addToCase(2));
        // add an item that fits
        when(gearlist.notFull(item1)).thenReturn(true);
        assertTrue(packer.addToCase(1));
        // Verify suitcase now has one item
        when(gearlist.size()).thenReturn(1);
        assertEquals(1,packer.numItems());
        assertEquals(2,desiredGear.size());
        // verify the proper item was removed from desiredGear
        assertEquals("A",desiredGear.get(0).toString());
        assertEquals("C",desiredGear.get(1).toString());
    }

}
